package gov.va.vinci.dart.db.util;

import gov.va.vinci.dart.log4j2.CocoonModeContextSelector;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

@Component
public class HibernateSessionManagerProcessor implements InitializingBean {
    @Override
    public void afterPropertiesSet() throws Exception {
        if (CocoonModeContextSelector.getRunningMode().equalsIgnoreCase("dev")) {
            return;
        }

        EntityManagerFactory emf;
        try {
            emf = Persistence.createEntityManagerFactory("manager1");
            HibernateSessionManagerImpl.setEntityManagerFactory(emf);
        } catch (Throwable ex) {
            // Make sure you log the exception, as it might be swallowed
            System.err.println("Initial SessionFactory creation failed." + ex);
            ex.printStackTrace();
            throw new ExceptionInInitializerError(ex);
        }
    }
}
